--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNdsimSubstitute ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCresourceKitMode = 1
  local LOCpopupMenu       = undefined
  local LOCholdRotateWheels = false
  local LOCbodyColours     = #(DYNuiResourcesMaterials[1], DYNuiResourcesMaterials[2], DYNuiResourcesMaterials[3], DYNuiResourcesMaterials[4], DYNuiResourcesMaterials[5], DYNuiResourcesMaterials[6], DYNuiResourcesMaterials[7], DYNuiResourcesMaterials[8], DYNuiResourcesMaterials[9])

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNmakeDsimSubstitutePopUpMenu FUNlv =
  (
    DYNdsimSubstitute.LOCpopupMenu = undefined
    if DYNdsimSubstitute.dnListView1.Items.count > 0 then
    (
      local LOCexe = "rcmenu LOCpopupMenu\n"
      LOCexe += "(\n"
      LOCexe += "  menuItem  MNDYNselectAll       checked:false\n"
      LOCexe += "  separator MNDYNseparator1\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[5] + "\"\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNselectTypeAll checked:false\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on LOCpopupMenu open do\n"
      LOCexe += "  (\n"
      LOCexe += "    MNDYNselectAll.text     = DYNuiResourcesMenus[14]\n"
      LOCexe += "    MNDYNselectTypeAll.text = DYNuiResourcesMenus[18]\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectAll  picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    for i = 1 to DYNdsimSubstitute.dnListView1.Items.count do (DYNdsimSubstitute.dnListView1.Items.item[i-1].selected = true)\n"
      LOCexe += "    local LOCnodeArray = #()\n"
      LOCexe += "    for i = 1 to DYNdsimSubstitute.dnListView1.selectedItems.count do\n"
      LOCexe += "    (\n"
      LOCexe += "       local LOCnode = maxOps.getNodeByHandle (DYNdsimSubstitute.dnListView1.selectedItems.item[i-1].name as integer)\n"
      LOCexe += "       if isValidNode LOCnode then append LOCnodeArray LOCnode\n"
      LOCexe += "    )\n"
      LOCexe += "    select LOCnodeArray\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectTypeAll  picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCtype = (filterString DYNdsimSubstitute.dnListView1.selectedItems.item[0].SubItems.item[2].text \" \")[1]\n"
      LOCexe += "    for i = 1 to DYNdsimSubstitute.dnListView1.Items.count do\n"
      LOCexe += "    (\n"
      LOCexe += "      local LOCcurrentType = (filterString DYNdsimSubstitute.dnListView1.Items.item[i-1].SubItems.item[2].text \" \")[1]\n"
      LOCexe += "      if LOCtype == LOCcurrentType then DYNdsimSubstitute.dnListView1.Items.item[i-1].selected = true\n"
      LOCexe += "    )\n"
      LOCexe += "    local LOCnodeArray = #()\n"
      LOCexe += "    for i = 1 to DYNdsimSubstitute.dnListView1.selectedItems.count do\n"
      LOCexe += "    (\n"
      LOCexe += "       local LOCnode = maxOps.getNodeByHandle (DYNdsimSubstitute.dnListView1.selectedItems.item[i-1].name as integer)\n"
      LOCexe += "       if isValidNode LOCnode then append LOCnodeArray LOCnode\n"
      LOCexe += "    )\n"
      LOCexe += "    select LOCnodeArray\n"
      LOCexe += "  )\n"
      LOCexe += ")\n"

      DYNdsimSubstitute.LOCpopupMenu = Execute LOCexe

      registerRightClickMenu DYNdsimSubstitute.LOCpopupMenu
    )
  )

  fn DSIMFUNobjectsSelected =
  (
    DYNdsimSubstitute.dnListView1.selecteditems.clear()

    local LOCobjects     = getCurrentSelection()

    for i in LOCobjects do
    (
      local LOClistItem = DYNdsimSubstitute.dnListView1.items.item[(i.inode.handle as string)]
      if LOClistItem != undefined then (LOClistItem.selected = true)
    )
    if DYNdsimSubstitute.dnListView1.selecteditems.count > 0 then
    (
      DYNdsimSubstitute.dnListView1.selectedItems.item[0].ensureVisible()
    )
  )

  fn DSIMFUNobjectsDeleted =
  (
    --- Get array of nodes about to be deleted, or undefined if callback broadcasted
    local LOCnotifyParam = callbacks.notificationParam()

    if LOCnotifyParam != undefined then
    (
      for i in LOCnotifyParam do
      (
        local LOClistItem = DYNdsimSubstitute.dnListView1.items.item[(i.inode.handle as string)]
        if LOClistItem != undefined then LOClistItem.remove()
      )
    )
  )

  fn DSIMFUNsubstituteVehicles FUNprogress FUNstatus FUNrotateWheels =
  (
    local LOCmodArray = #()
    local LOCnewVehNodeArray = #()
    local LOCnewVehDataArray = #()
    DYNdsimSubstitute.BUDYNokok.enabled = false
    DYNdsimSubstitute.BUDYNapply.enabled = false

    undo off
    (
      callbacks.removescripts id:#DYNdsimSubstitute
      DYNFUNremoveCSProllouts()
      actionMan.executeAction 0 "300"
      DYNFUNloadVSPnodeCallBacks false
      (
        with redraw off
        (
          local LOCexposeTM = exposeTM()

          --- Gather Vehicles to be modified
          for i = 1 to DYNdsimSubstitute.dnListView1.items.count do
          (
            if DYNdsimSubstitute.dnListView1.items.item[i-1].tag != undefined then -- rem zero based indexes
            (
              append LOCmodArray (DYNdsimSubstitute.dnListView1.items.item[i-1].tag + "|" + ((i - 1) as string))
            )
            DYNdsimSubstitute.dnListView1.items.item[i-1].backcolor = (dotNetClass "System.Drawing.Color").fromARGB 255 255 255
          )

          --- Substitue vehicle
          local LOCbitArray = #{}; LOCbitArray.count = LOCmodArray.count
          for i = 1 to LOCmodArray.count do
          (
            FUNprogress.value = ((i as float) / (LOCmodArray.count as float) * 100.0)

            local LOCdataArray  = filterString LOCmodArray[i] "|"
            local LOCsizeArray  = DYNFUNobjectINIparams (getFilenameFile LOCdataArray[2]) 1 DYNdsimSubstitute.LOCresourceKitMode
            local LOCbaseObj    = maxOps.getNodeByHandle (LOCdataArray[1] as integer)
            local LOCmatID      = LOCdataArray[3] as integer
            local LOCshadowFlag = -1

            if isValidNode LOCbaseObj then
            (
              FUNstatus.text = LOCbaseObj.name + " : " + DYNuiResourcesStatusMessages[29]

              --- If Max File, then Merge Vehicle Geometry From Selected MAX File
              if (stricmp (substring LOCsizeArray[5] (LOCsizeArray[5].count - 3) -1) ".max") == 0 then
              (
                local LOCmasterObject

                --- Ensure that source object is not instanced to other objects - it must be unique
                local LOColdObject = LOCbaseObj
                LOCbaseObj         = copy LOCbaseObj
                if (getAppData LOColdObject 422) != undefined and (getAppData LOColdObject 423) != undefined and (getAppData LOColdObject 424) != undefined and (getAppData LOColdObject 425) != undefined and (getAppData LOColdObject 426) != undefined and (getAppData LOColdObject 427) != undefined and (getAppData LOColdObject 428) != undefined then
                (
                  DYNFUNgenObjAppData LOCbaseObj (getAppData LOColdObject 422) (getAppData LOColdObject 423) (getAppData LOColdObject 424) (getAppData LOColdObject 425) (getAppData LOColdObject 426) (getAppData LOColdObject 427) (getAppData LOColdObject 428)
                  setAppData LOCbaseObj 421 "DSIM"
                )
                LOCbaseObj.name      = LOColdObject.name
                LOCbaseObj.wirecolor = LOColdObject.wirecolor
                LOCbaseObj.material  = LOColdObject.material

                for ii in LOColdObject.children do delete ii
                delete LOColdObject

                --- check if this vehicle type/body colour/shadow type has been used before in this scene
                local LOCsearchString = (LOCmatID as string) + "|" + (LOCdataArray[2]) + "|-1"
                local LOCfindStatus   = findItem LOCnewVehDataArray LOCsearchString
                if LOCfindStatus > 0 then
                (
                  LOCmasterObject = maxOps.getNodeByHandle LOCnewVehNodeArray[LOCfindStatus]
                  instanceReplace LOCbaseObj LOCmasterObject
                  LOCbaseObj.material = LOCmasterObject.material
                )

                --- If instance was not found, merge geometry from max file
                if not (isValidNode LOCmasterObject) then
                (
                  --- If not used before, merge MAX file
                  mergeMAXfile LOCsizeArray[5] #noRedraw #select #mergedups #useSceneMtlDups quiet:true
                  LOCmasterObject = selection[1]

                  --- Remove Any Modifiers From Merged Vehicle Gometry
                  if isValidNode LOCmasterObject then
                  (
                    if LOCmasterObject.modifiers.count > 0 then collapseStack LOCmasterObject
                  )

                  if LOCmasterObject.material == undefined then
                  (
                    LOCmasterObject.material = if sceneMaterials[DYNmatNameVehicles] == undefined then (DYNFUNmakeCivilViewVehicles (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameVehicleMaps + "\\")) else sceneMaterials[DYNmatNameVehicles]
                  )

                  --- Apply Selected Body Colour to Merged Mesh
                  if classof LOCmasterObject == Editable_Mesh and (try (striCmp (subString LOCmasterObject.material.name 1 DYNmatNameVehicles.count) DYNmatNameVehicles == 0) catch (false)) then
                  (
                    for iii = 1 to LOCmasterObject.numfaces do if (getfacematid LOCmasterObject iii) == 9 then (setfacematid LOCmasterObject iii LOCmatID)
                  )

                  if classof LOCmasterObject == Editable_Poly and (try (striCmp (subString LOCmasterObject.material.name 1 DYNmatNameVehicles.count) DYNmatNameVehicles == 0) catch (false)) then
                  (
                    local LOCbitArray = #{}
                    LOCbitArray.count = LOCmasterObject.numfaces
                    for iii = 1 to LOCmasterObject.numfaces do (if (polyOp.getFaceMatID LOCmasterObject iii) == 9 do LOCbitArray[iii] = true)
                    PolyOp.setFaceMatID LOCmasterObject LOCbitArray LOCmatID
                  )

                  --- Move Merged Vehicle to position of Donor Object
                  if isValidNode LOCmasterObject then
                  (
                    CenterPivot LOCmasterObject

                    --- move pivot point to base of object (if necessary)
                    in coordsys local (LOCmasterObject.objectoffsetpos.z += (LOCmasterObject.pos.z - LOCmasterObject.min.z))

                    --- extract xform info from transform to xform modifier on top of object
                    ResetXform LOCmasterObject
                    instanceReplace LOCbaseObj LOCmasterObject
                    if classof LOCbaseObj.baseObject == Editable_Mesh or classof LOCbaseObj.baseObject == Editable_Poly then collapseStack LOCbaseObj

                    LOCbaseObj.material = LOCmasterObject.material

                    delete LOCmasterObject
                  )

                  --- Add New Vehicle ToTemorary Arrays (Used For Applying Instances)
                  append LOCnewVehNodeArray LOCbaseObj.inode.handle
                  append LOCnewVehDataArray ((LOCmatID as string) + "|" + (LOCdataArray[2]) + "|-1")
                )

                --- Extra Stuff vor V1.1
                LOCexposeTM.exposeNode = LOCbaseObj
                LOCbaseObj.objectoffsetpos.y = LOCexposeTM.worldBoundingBoxLength / 2.0
              )

              --- IF RPC CONTENT SELECTED -----------------------------------------------------------------
              if (stricmp (substring LOCsizeArray[5] (LOCsizeArray[5].count - 3) -1) ".rpc") == 0 then
              (
                local LOCmasterObject = try (RPC()) catch () -- undefined if RPC plugin is not loaded
                if isValidNode LOCmasterObject then
                (
                  --- specify RPC content if plugin supports it
                  if classof LOCmasterObject.specifyRPC == InterfaceFunction then
                  (
                    LOCmasterObject.SpecifyRpc(LOCsizeArray[5])
                  )
                )
                else -- if RPC plugin not loaded, simply create a dummy object
                (
                  LOCmasterObject = dummy boxsize:[5.0,2.5,2.0]
                )

                --- TEMP: Move Merged Vehicle to position of Donor Object
                if isValidNode LOCmasterObject then
                (
                  CenterPivot LOCmasterObject

                  in coordsys local (LOCmasterObject.objectoffsetpos.z += (LOCmasterObject.pos.z - LOCmasterObject.min.z)) -- to move pivot point to base of object (if necessary)
                  instanceReplace LOCbaseObj LOCmasterObject
                  delete LOCmasterObject
                )
              )

              --- Update AppData ---
              if isValidNode LOCbaseObj then
              (
                setAppData LOCbaseObj 423 LOCdataArray[3]
                setAppData LOCbaseObj 424 LOCdataArray[2]
              )
            )
            gc()
          )
        )
        redrawViews()

        if isValidNode LOCexposeTM then delete LOCexposeTM

        FUNprogress.value = 0.0
        FUNstatus.text = DYNuiResourcesStatusMessages[30]
      )

      --- Apply Rotating Wheels to Unique Vehicles (Editable Polys Only; Instances Automatically Caught)
      if FUNrotateWheels then
      (
        for ii in LOCnewVehNodeArray do
        (
          local LOCuniqueNode = maxOps.getNodeByHandle ii
          if isValidNode LOCuniqueNode then (DYNFUNdetachWheelsFromVehiclePolyAndRotate LOCuniqueNode 14 15)
        )
      )

      --- Tidy Up and Redraw Views
      DYNFUNloadVSPnodeCallBacks true
      DYNFUNnodeCreatedCallback()
      callbacks.addscript #selectedNodesPreDelete "DYNdsimSubstitute.DSIMFUNObjectsDeleted()"  id:#DYNdsimSubstitute
      callbacks.addscript #selectionSetChanged    "DYNdsimSubstitute.DSIMFUNObjectsSelected()" id:#DYNdsimSubstitute
      DYNdsimSubstitute.DSIMFUNfillVehicleList DYNdsimSubstitute.dnListView1 DYNdsimSubstitute.dnProgress DYNobjHandles[1]
    )

    LOCmodArray --return value
  )

  fn DSIMFUNfillVehicleList FUNlv1 FUNprogress FUNarray =
  (
    local LOCtheRange1             = #()
    local LOCcnt                   = 0
    local LOCdvspVehicleTypeArray  = #()
    local LOCdvspVehicleCountArray = #()
    local LOCvehTypeArray          = #()

    FUNlv1.Items.clear()

    for i in FUNarray do
    (
      FUNprogress.value = ((LOCcnt as float) / (FUNarray.count as float) * 100.0)
      local LOCobj = maxOps.getNodeByHandle i
      if (getAppData LOCobj 421) == "DSIM" then
      (
        local LOCli  = dotNetObject "System.Windows.Forms.ListViewItem" LOCobj.name -- create a ListViewItem object with the object's name
        LOCli.imageIndex = 1

        --LOCli.forecolor = (dotNetClass "System.Drawing.Color").fromARGB LOCobj.wirecolor.r LOCobj.wirecolor.g LOCobj.wirecolor.b
        LOCli.name = i as string

        --Then add all the sub-items with the desired string values:
        local LOCiniFile = try (getfilenamefile (getAppData LOCobj 424) as string) catch ("--"); if LOCiniFile == "" then LOCiniFile = "--"
        local LOCbodyCol = try ((getAppData LOCobj 423) as string) catch ("--"); if LOCbodyCol == "0" then LOCbodyCol = "--"
        if LOCbodyCol as integer != undefined then LOCbodyCol = LOCbodyColours[LOCbodyCol as integer]

        --- Build Array of DVSP Vehicle Types in Scene
        if findItem LOCdvspVehicleTypeArray LOCiniFile == 0 then
        (
          append LOCdvspVehicleTypeArray LOCiniFile
          append LOCdvspVehicleCountArray 1
        )
        else
        (
          LOCdvspVehicleCountArray[findItem LOCdvspVehicleTypeArray LOCiniFile] += 1
        )

        local LOCappData425 = filterString (getAppData LOCobj 425) "|"
        local sub_li = LOCli.SubItems.add (try (LOCappData425[3]) catch ("--"))
        local sub_li = LOCli.SubItems.add (try (LOCappData425[4]) catch ("--"))
        local sub_li = LOCli.SubItems.add LOCiniFile
        local sub_li = LOCli.SubItems.add LOCbodyCol
        local sub_li = LOCli.SubItems.add " "
        local sub_li = LOCli.SubItems.add (try ((LOCobj.mesh.numfaces) as string) catch ("--"))
        append LOCtheRange1 LOCli

        if findItem LOCvehTypeArray (try (LOCappData425[4]) catch ("--")) == 0 then append LOCvehTypeArray (try (LOCappData425[4]) catch ("--"))
      )
      LOCcnt += 1
    )
    FUNlv1.Items.AddRange LOCtheRange1

    --- Highlight all selected DSIM objects in the LV
    DYNdsimSubstitute.DSIMFUNObjectsSelected()

    --- Finish Off
    DYNdsimSubstitute.DDDYNcats.items = LOCvehTypeArray
    DYNdsimSubstitute.LBDYNstatus.text = DYNuiResourcesStatusMessages[30]
    FUNprogress.value = 0.0
  )

  fn DSIMFUNfillInTreeView FUNtv FUNmode =
  (
    DYNdsimSubstitute.dnTreeView.nodes.clear()
    local LOCiniPath     = DYNFUNsetINIpath 1 FUNmode
    local LOCrootNode    = FUNtv.Nodes.add "[]" (DYNuiResourcesCvExplorer[13]) 37 37
    LOCrootNode.tag      = ""
    DYNdsimSubstitute.dnTreeView.selectedNode = LOCrootNode

    ------------------- ADD UNGROUPED FILES -----------------------

    --- Extract Ungrouped INI Files from current folder
    local LOCexFileBaseArray = DYNFUNiniGetMissingValues 1 "Group" "Name" DYNdsimSubstitute.LOCresourceKitMode

    if LOCexFileBaseArray.count > 0 then
    (
      --- Create Ungrouped Node
      local newNode = theNode.Nodes.add ("[" + "ungrouped" + "]") DYNuiResourcesLabels[523] 37 37
      newNode.tag = ""

      for ii = 1 to LOCexFileBaseArray.count do
      (
        local newcNode = newNode.Nodes.add ("!" + (DYNFUNlowerCase LOCexFileBaseArray[ii]) + ".ini") LOCexFileBaseArray[ii] 1 1
        newcNode.tag   = "1|" + (i as string) + "|" + (ii as string) + "|" + (LOCiniPath + LOCexFileBaseArray[ii] + ".ini")
      )
    )

    --------------------- GROUPED FILES --------------------------------------------------------------------------------------------------------------------------------

    --- Extract Range of Group Names for Current INI File Type
    local LOCgroupNamesArray = DYNFUNiniGetUniqueValues 1 "Group" "Name" DYNdsimSubstitute.LOCresourceKitMode

    for i = 1 to LOCgroupNamesArray.count do
    (
      --- Display each Group Name Node in Panel
      local LOCgroupNode     = LOCrootNode.Nodes.add ("[" + (DYNFUNlowerCase LOCgroupNamesArray[i]) + "]") LOCgroupNamesArray[i] 37 37
      LOCgroupNode.tag = ""

      --- Get Files for Each Group Listed
      local LOCfileBaseArray = DYNFUNiniGetbySectionPair 1 "Group" "Name" LOCgroupNamesArray[i] DYNdsimSubstitute.LOCresourceKitMode

      --- Display files for each group listed
      for ii = 1 to LOCfileBaseArray.count do
      (
        local LOCiniNode    = LOCgroupNode.Nodes.add ("!" + (DYNFUNlowerCase LOCfileBaseArray[ii]) + ".ini") LOCfileBaseArray[ii] 1 1-- File Name KEYS always in Lower Case
        LOCiniNode.tag      = LOCiniPath + LOCfileBaseArray[ii] + ".ini"
      )

      LOCgroupNode.expand()
    )
    LOCrootNode.expand()
  )

  fn DYNFUNsetupPreviewPane FUNstring1 FUNstring2 =
  (
    local LOCpreview = ""
    local LOCloadSwitch  = false

    LOCloadSwitch = if (substring FUNstring1 1 1) != "!" then false else true -- If a specific INI file is not selected

    if LOCloadSwitch then
    (
      local LOCiniObjectArray = DYNFUNobjectINIparams FUNstring2 1 DYNdsimSubstitute.LOCresourceKitMode
      LOCpreview = LOCiniObjectArray[7]
      LOCloadSwitch = if (try ((getfiles LOCpreview).count) catch (0)) > 0  then true else false
    )

    DYNdsimSubstitute.BMDYNpreview.bitmap = DYNFUNrenderBitMap 128 128 LOCpreview
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  dotNetControl dnListView1       "System.Windows.Forms.ListView"    pos:[8,6]    width:450 height:457
  dotNetControl dnTreeView        "System.Windows.Forms.TreeView"    pos:[465,145] width:180 height:318
  dotNetControl dnResourceKitList "System.Windows.Forms.ListView"    pos:[465,60]  width:311 height:80
  dotNetControl dnProgress        "System.Windows.Forms.ProgressBar" pos:[8,506]  width:767 height:12

  groupbox GBDYNgroup01     pos:[465,3] width:311 height:47
  label LBDYNcategory       pos:[475,24] width:75
  dropdownList DDDYNcats    pos:[550,21] width:171
  button BUDYNselect        pos:[723,20] width:45

  bitmap BMDYNpreview       pos:[649,145] width:128 height:128

  label LBDYNcolours        pos:[651,280] width:128
  dropdownList DDDYNcolours "" pos:[651,298] width:128

  button BUDYNupdate        pos:[650,330] width:128 height:22
  checkbox CKDYNrotation    pos:[650,435] width:128 height:40

  button BUDYNhelp          pos:[7,476]   width:102 height:22
  button BUDYNokok          pos:[463,476] width:102 height:22 enabled:false
  button BUDYNapply         pos:[568,476] width:102 height:22 enabled:false
  button BUDYNcanc          pos:[673,476] width:102 height:22

  label LBDYNstatus         pos:[8,526]   width:767 height:18

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNdsimSubstitute open do
  (
    DYNdsimSubstitute.title   = DYNuiRolloutNames[40]

    GBDYNgroup01.text         = DYNuiResourcesGroups[108]

    BUDYNokok.text            = DYNuiResourcesButtons[1]
    BUDYNapply.text           = DYNuiResourcesButtons[2]
    BUDYNcanc.text            = DYNuiResourcesButtons[3]
    BUDYNhelp.text            = DYNuiResourcesButtons[5]
    BUDYNupdate.text          = DYNuiResourcesButtons[81]
    BUDYNselect.text          = DYNuiResourcesButtons[72]

    LBDYNcolours.text         = DYNuiResourcesLabels[371]
    LBDYNcategory.text        = DYNuiResourcesLabels[370]
    CKDYNrotation.text        = DYNuiResourcesLabels[595]

    DDDYNcolours.items        = #(DYNuiResourcesLabels[369]) + LOCbodyColours

    CKDYNrotation.checked     = LOCholdRotateWheels = if DYNINIrotateWheels == "0" then false else true

    --- Build Array of Grouped and Categorised Object INI files
    DYNobjectPlacer.DYNFUNmakeINIobjFileArrays()

    --- Set Up ListView Displays
    DYNFUNdnListViewStyle dnListView1 false true
    dnListView1.smallimageList = DYNdnSmImageList

    dnListView1.Columns.add DYNuiResourcesLvColumns[55] 92
    dnListView1.Columns.add DYNuiResourcesLvColumns[56] 58
    dnListView1.Columns.add DYNuiResourcesLvColumns[57] 59
    dnListView1.Columns.add DYNuiResourcesLvColumns[69] 117
    dnListView1.Columns.add DYNuiResourcesLvColumns[68] 104
    dnListView1.Columns.add " "                         100
    dnListView1.Columns.add DYNuiResourcesLvColumns[10] 43

    dnListView1.Columns.item[0].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Left
    dnListView1.Columns.item[1].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView1.Columns.item[2].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView1.Columns.item[3].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView1.Columns.item[4].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView1.Columns.item[5].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center
    dnListView1.Columns.item[6].TextAlign =  (dotNetClass "System.Windows.Forms.HorizontalAlignment").Center

    --- Resource Kit Selection
    DYNFUNresourceKitListViewStyleAndContent DYNiconsPath LOCresourceKitMode false dnResourceKitList

    --- Fill ListView
    DSIMFUNfillVehicleList dnListView1 dnProgress DYNobjHandles[1]

    DYNFUNnodeCreatedCallback()

    --- Fill TreeView
    DYNFUNdnTreeViewStyle dnTreeView
    dnTreeView.imageList = DYNdnSmImageList
    DSIMFUNfillInTreeView dnTreeView LOCresourceKitMode

    callbacks.removescripts id:#DYNdsimSubstitute
    callbacks.addscript #selectedNodesPreDelete "DYNdsimSubstitute.DSIMFUNObjectsDeleted()"  id:#DYNdsimSubstitute
    callbacks.addscript #selectionSetChanged    "DYNdsimSubstitute.DSIMFUNObjectsSelected()" id:#DYNdsimSubstitute
  )

  on DYNdsimSubstitute close do
  (
    callbacks.removescripts id:#DYNdsimSubstitute
  )

  on dnResourceKitList ItemSelectionChanged arg do
  (
    if arg.isSelected then
    (
      LOCresourceKitMode = arg.item.ImageIndex
      DSIMFUNfillInTreeView dnTreeView LOCresourceKitMode
    )
  )

  on BUDYNupdate pressed do
  (
    if dnListView1.selectedItems.count > 0 then
    (
      BUDYNokok.enabled = true
      BUDYNapply.enabled = true

      local LOCselNode = dnTreeView.selectedNode

      --- If Single Vehicle Selected
      if (subString LOCselNode.name 1 1) == "!" then
      (
        for i = 1 to dnListView1.selectedItems.count do
        (
          --- Apply Vehicle Type
          dnListView1.selectedItems.item[i-1].subItems.item[3].text = LOCselNode.text
          dnListView1.selectedItems.item[i-1].subItems.item[6].text = DYNuiResourcesLabels[204]

          --- Apply Body Colour
          local LOCid3 = if DDDYNcolours.selection == 1 then (random 1 9) else (DDDYNcolours.selection - 1)
          dnListView1.selectedItems.item[i-1].subItems.item[4].text = LOCbodyColours[LOCid3]

          --- Add Tag To ListView Item (must be last)
          dnListView1.selectedItems.item[i-1].tag = dnListView1.selectedItems.item[i-1].name + "|" + LOCselNode.tag + "|" + (LOCid3 as string) + "|-1"

          dnListView1.selectedItems.item[i-1].backcolor = (dotNetClass "System.Drawing.Color").fromARGB 255 255 175
        )
      )

      --- If Category Node Selected
      if LOCselNode.name != "[]" and (subString LOCselNode.name 1 1) == "[" then
      (
        for i = 1 to dnListView1.selectedItems.count do
        (
          local LOCid1 = random 1 LOCselNode.nodes.count

          --- Apply Vehicle Type
          dnListView1.selectedItems.item[i-1].subItems.item[3].text = LOCselNode.nodes.item[LOCid1-1].text
          dnListView1.selectedItems.item[i-1].subItems.item[6].text = DYNuiResourcesLabels[204]

          --- Apply Body Colour
          local LOCid3 = if DDDYNcolours.selection == 1 then (random 1 9) else (DDDYNcolours.selection - 1)
          dnListView1.selectedItems.item[i-1].subItems.item[4].text = LOCbodyColours[LOCid3]

          --- Add Tag To ListView Item (must be last)
          dnListView1.selectedItems.item[i-1].tag = dnListView1.selectedItems.item[i-1].name + "|" + LOCselNode.nodes.item[LOCid1-1].tag + "|" + (LOCid3 as string) + "|-1"

          dnListView1.selectedItems.item[i-1].backcolor = (dotNetClass "System.Drawing.Color").fromARGB 255 255 175
        )
      )

      --- If Root Node Selected
      if LOCselNode.name == "[]" then
      (
        for i = 1 to dnListView1.selectedItems.count do
        (
          local LOCid1 = random 1 LOCselNode.nodes.count
          local LOCid2 = LOCselNode.nodes.item[LOCid1-1].nodes.count

          --- Apply Vehicle Type
          dnListView1.selectedItems.item[i-1].subItems.item[3].text = LOCselNode.nodes.item[LOCid1-1].nodes.item[LOCid2-1].text
          dnListView1.selectedItems.item[i-1].subItems.item[6].text = DYNuiResourcesLabels[204]

          --- Apply Body Colour
          local LOCid3 = if DDDYNcolours.selection == 1 then (random 1 9) else (DDDYNcolours.selection - 1)
          dnListView1.selectedItems.item[i-1].subItems.item[4].text = LOCbodyColours[LOCid3]

          --- Add Tag To ListView Item (must be last)
          dnListView1.selectedItems.item[i-1].tag = dnListView1.selectedItems.item[i-1].name + "|" + LOCselNode.nodes.item[LOCid1-1].nodes.item[LOCid2-1].tag + "|" + (LOCid3 as string) + "|-1"

          dnListView1.selectedItems.item[i-1].backcolor = (dotNetClass "System.Drawing.Color").fromARGB 255 255 175
        )
      )
    )
    else
    (
      messagebox (DYNuiResourcesErrorsWarnings[53]) title:DYNuiResourcesTitlebars[1]
    )
  )

  on dnListView1 mouseUp arg do
  (
    if arg.button == DYNdnmouseClass.right then
    (
      DYNFUNmakeDsimSubstitutePopUpMenu dnListView1
      if LOCpopupMenu != undefined then popupMenu LOCpopupMenu
    )


    local LOCnodeArray = #()
    for i = 1 to dnListView1.selectedItems.count do
    (
       local LOCnode = maxOps.getNodeByHandle (dnListView1.selectedItems.item[i-1].name as integer)
       if isValidNode LOCnode then append LOCnodeArray LOCnode
    )
    select LOCnodeArray
  )

  on BUDYNselect pressed do
  (
    callbacks.removescripts id:#DYNdsimSubstitute
    DYNdsimSubstitute.dnListView1.selecteditems.clear()
    clearSelection()

    local LOCnodeArray = #()
    for i = 1 to DYNdsimSubstitute.dnListView1.items.count do
    (
      dnProgress.value = ((i as float) / (DYNdsimSubstitute.dnListView1.items.count as float) * 100.0)

      if dnListView1.items.item[i-1].subItems.item[2].text == DDDYNcats.selected then
      (
        dnListView1.items.item[i-1].selected = true
        local LOCnode = maxOps.getNodeByHandle (dnListView1.Items.item[i-1].name as integer)
        if isValidNode LOCnode then append LOCnodeArray LOCnode
      )
    )
    dnProgress.value = 0.0
    select LOCnodeArray
    callbacks.addscript #selectedNodesPreDelete "DYNdsimSubstitute.DSIMFUNObjectsDeleted()"  id:#DYNdsimSubstitute
    callbacks.addscript #selectionSetChanged    "DYNdsimSubstitute.DSIMFUNObjectsSelected()" id:#DYNdsimSubstitute
    if DYNdsimSubstitute.dnListView1.selecteditems.count > 0 then
    (
      DYNdsimSubstitute.dnListView1.selectedItems.item[0].ensureVisible()
    )
  )

  on CKDYNrotation changed arg do
  (
    LOCholdRotateWheels = arg
  )

  on dnTreeView NodeMouseClick arg do
  (
    DYNFUNsetupPreviewPane arg.node.name arg.node.text
  )

  on BUDYNokok pressed do
  (
    DSIMFUNsubstituteVehicles dnProgress LBDYNstatus LOCholdRotateWheels
    destroyDialog DYNdsimSubstitute
  )

  on BUDYNapply pressed do
  (
    DSIMFUNsubstituteVehicles dnProgress LBDYNstatus LOCholdRotateWheels
  )

  on BUDYNcanc pressed do
  (
    destroyDialog DYNdsimSubstitute
  )

  on BUDYNhelp pressed do DYNFUNopenHelp 13219 -- id_cv_vehicle_substitution
)
